<?= $this-> include('templates/header');?>
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="<?= base_url('ns-admin') ?>"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?= isset($pageTitle) ? esc($pageTitle) : "" ?></li>
            </ol>
        </nav>
        <div class="row g-4">
            <div class="col-12">
                <div class="card h-100">
                    <div class="card-body p-4">
                        <form action="<?= base_url('/ns-admin/create_sections_handler') ?>" name="addeditsections" method="POST" enctype="multipart/form-data">
                            <?= csrf_field() ?>
                            <input  type="hidden" name="section_id" value="<?= isset($section_id) ? esc($section_id) : '' ?>" />
                        
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Section Title</label>
                                <div class="col-sm-10">
                                    <input type="text" name="section_name" class="form-control" value="<?= isset($section_id) ? esc($row['section_name']) : '' ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Section Type</label>
                                <div class="col-sm-10">
                                    <select name="section_type" id="section_type" class="nsofts-select" required>
                                        <option value="">--Select Type --</option>
                                        <?php if(isset($section_id)){ ?>
                                            <option value="category" <?php if($row['section_type']=='category'){?>selected<?php }?>>Categories</option>
                                            <option value="countries" <?php if($row['section_type']=='countries'){?>selected<?php }?>>Countries</option>
                                            <option value="radio" <?php if($row['section_type']=='radio'){?>selected<?php }?>>Radio</option>
                                            <option value="podcasts" <?php if($row['section_type']=='podcasts'){?>selected<?php }?>>Podcasts</option>
                                        <?php } else { ?>
                                            <option value="category">Categories</option>
                                            <option value="countries">Countries</option>
                                            <option value="radio">Radio</option>
                                            <option value="podcasts">Podcasts</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_cat" class="mb-3 row" <?php if(isset($section_id)){?> <?php if($row['section_type']!='category'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Categories</label>
                                <div class="col-sm-10">
                                    <select name="cat_post_id[]" id="cat_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Categories--</option>
                                        <?php foreach($resultCategory as $category_row){ ?>
                                            <?php if(isset($section_id)){ ?>
                                                <option value="<?= isset($category_row['cid']) ? esc($category_row['cid']) : '' ?>" <?php if(in_array($category_row['cid'], explode(",",$row['post_ids']))){?>selected<?php }?>><?= isset($category_row['category_name']) ? esc($category_row['category_name']) : '' ?></option>    
                                            <?php } else { ?>
                                                <option value="<?= isset($category_row['cid']) ? esc($category_row['cid']) : '' ?>"><?= isset($category_row['category_name']) ? esc($category_row['category_name']) : '' ?></option>    
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_countries" class="mb-3 row" <?php if(isset($section_id)){?> <?php if($row['section_type']!='countries'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Countries</label>
                                <div class="col-sm-10">
                                    <select name="countries_post_id[]" id="countries_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Countries--</option>
                                        <?php foreach($resultCountries as $cou_row){ ?>
                                            <?php if(isset($section_id)){ ?>
                                                <option value="<?= isset($cou_row['sid']) ? esc($cou_row['sid']) : '' ?>" <?php if(in_array($cou_row['sid'], explode(",",$row['post_ids']))){?>selected<?php }?>><?= isset($cou_row['countries_name']) ? esc($cou_row['countries_name']) : '' ?></option> 
                                            <?php } else { ?>
                                                <option value="<?= isset($cou_row['sid']) ? esc($cou_row['sid']) : '' ?>" ><?= isset($cou_row['countries_name']) ? esc($cou_row['countries_name']) : '' ?></option> 
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_radio"  class="mb-3 row" <?php if(isset($section_id)){?> <?php if($row['section_type']!='radio'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Radio</label>
                                <div class="col-sm-10">
                                    <select name="radio_post_id[]" id="radio_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Radio--</option>
                                        <?php foreach($resultRadios as $radio_row){ ?>
                                            <?php if(isset($section_id)){ ?>
                                                <option value="<?= isset($radio_row['id']) ? esc($radio_row['id']) : '' ?>" <?php if(in_array($radio_row['id'], explode(",",$row['post_ids']))){?>selected<?php }?>><?= isset($radio_row['radio_title']) ? esc($radio_row['radio_title']) : '' ?></option>
                                            <?php } else { ?>
                                                <option value="<?= isset($radio_row['id']) ? esc($radio_row['id']) : '' ?>"><?= isset($radio_row['radio_title']) ? esc($radio_row['radio_title']) : '' ?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_podcasts"  class="mb-3 row" <?php if(isset($section_id)){?> <?php if($row['section_type']!='podcasts'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Podcast</label>
                                <div class="col-sm-10">
                                    <select name="podcast_post_id[]" id="podcast_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Podcast--</option>
                                        <?php foreach($resultPodcast as $podcast_row){ ?>
                                            <?php if(isset($section_id)){ ?>
                                                <option value="<?= isset($podcast_row['pid']) ? esc($podcast_row['pid']) : '' ?>" <?php if(in_array($podcast_row['pid'], explode(",",$row['post_ids']))){?>selected<?php }?>><?= isset($podcast_row['podcast_name']) ? esc($podcast_row['podcast_name']) : '' ?></option>
                                            <?php } else { ?>
                                                <option value="<?= isset($podcast_row['pid']) ? esc($podcast_row['pid']) : '' ?>"><?= isset($podcast_row['podcast_name']) ? esc($podcast_row['podcast_name']) : '' ?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <div class="mb-3 row">
                                    <label class="col-sm-2 col-form-label">&nbsp;</label>
                                    <div class="col-sm-10">
                                        <button type="submit" name="submit" class="btn btn-primary" style="min-width: 120px;"><?=$pageSave?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?= $this-> include('templates/footer');?>
<script type="text/javascript">
    $(document).ready(function(e) {
        $("#section_type").change(function(){
          var type=$("#section_type").val();
          if(type=="category"){
            $("#section_cat").show();
            $("#section_countries").hide();
            $("#section_radio").hide();
            $("#section_podcasts").hide();
            
          } else if(type=="countries"){
            $("#section_cat").hide();
            $("#section_countries").show();
            $("#section_radio").hide();
            $("#section_podcasts").hide();
            
          } else if(type=="radio"){
            $("#section_cat").hide();
            $("#section_countries").hide();
            $("#section_radio").show();
            $("#section_podcasts").hide();
            
          } else if(type=="podcasts"){
            $("#section_cat").hide();
            $("#section_countries").hide();
            $("#section_radio").hide();
            $("#section_podcasts").show();
            
          } else {
            $("#section_cat").hide();
            $("#section_countries").hide();
            $("#section_radio").hide();
            $("#section_podcasts").hide();
            
          }
        });
    });
</script>